AllRound_ExtensionSayings = {};

function AllRound_ExtensionSayings:updateSayings()	
	if not g_currentMission.hlHudSystem.textTicker.isOn then return;end;
	if AllRound_Extension.sayings.acceptsLanguage[g_languageShort] ~= nil then
		if AllRound_Extension.values.sayings.on[1] > 1 then			
			if AllRound_Extension.sayings.canViewText() then				
				if #AllRound_Extension.sayings.randomTexts > 0 then AllRound_Extension.sayings.addRandomMsg( AllRound_Extension.sayings.getRandomMsg(), true);else AllRound_Extension.sayings.setNextTime();end;				
			elseif AllRound_Extension.values.sayings.joke[1] > 1 and #AllRound_Extension.sayings.types["joke"] > 0 and AllRound_Extension.sayings.canViewJokeText() then
				AllRound_Extension.sayings.setNextJokeTime();
				if (g_currentMission.hlUtils.getRandomByKey ~= nil and g_currentMission.hlUtils.getRandomByKey( {ready=AllRound_Extension.values.sayings.jokeRandom[1],notReady=100-AllRound_Extension.values.sayings.jokeRandom[1]} ) == "ready") or g_currentMission.hlUtils.getRandomByKey == nil then
					g_currentMission.hlHudSystem.textTicker:addMsg( {text="__ --", isVisible=false, onDraw=AllRound_ExtensionSayings.onDrawJokeMsg, onClick=AllRound_ExtensionSayings.onClickJokeMsg, id="AllRound_Extension_JokeMsg"});
				end;
			end;			
		end;
	end;
end;

function AllRound_ExtensionSayings.onDrawJokeMsg(posData, msg)
	local overlayGroup = AllRound_Extension.values.guiMenu.overlays["defaultIcons"]["guiBox"];
	local overlayByName = AllRound_Extension.values.guiMenu.overlays.byName["defaultIcons"]["guiBox"];
	local overlayJokeMsg = overlayGroup[overlayByName[AllRound_Extension.sayings.msgIcon]]; 
	local overlayMouse = overlayGroup[overlayByName["leftMouse"]]; 
	g_currentMission.hlUtils.setOverlay(overlayJokeMsg, msg.pos, posData.y, posData.iconWidth, posData.iconHeight);
	g_currentMission.hlUtils.setOverlay(overlayMouse, msg.pos, posData.y, posData.iconWidth, posData.iconHeight);
	if msg.pos+posData.iconWidth <= posData.x+posData.width then 
		if string.find(msg.text, "-") then
			if g_currentMission.hlUtils.runsTimer("1sec", true) then 
				overlayMouse:render();
			end;
		elseif string.find(msg.text, "_") then
			overlayJokeMsg:render();
		end;		
	end;
end;

function AllRound_ExtensionSayings.onClickJokeMsg(args)
	if args == nil or type(args) ~= "table" or args.clickAreaTable == nil then return;end;
	if args.isDown then
		if args.button == Input.MOUSE_BUTTON_LEFT then			
			local msg = AllRound_Extension.sayings.getRandomMsg("joke", true);
			if msg ~= nil and msg.text ~= nil then
				g_currentMission.hlUtils.mouseOnOff(false, false); --force mouseOff				
				g_currentMission.hlHudSystem.textTicker:setRemoveMsgById(args.clickAreaTable.ownTable.id);					
				if g_currentMission.hlUtils.timers["jokeTimer"] ~= nil then return;end;
				g_currentMission.hlUtils.addTimer( {delay=1, name="jokeTimer", action=AllRound_ExtensionSayings.jokeTimerCallback, repeatable=false, ownTable={msg=msg.text}} );									
			end;			
		end;
	end;
end;

function AllRound_ExtensionSayings.jokeTimerCallback(timer)
	g_currentMission.hud:showInGameMessage("Joke",  timer.ownTable.msg, -1);
end;

function AllRound_ExtensionSayings:getRandomMsg(types, removeTypesMsg, typesOrRandom)
	local msg = {};
	if types == nil then
		local randomMsg = math.random(1, #AllRound_Extension.sayings.randomTexts);
		msg.text = AllRound_Extension.sayings.randomTexts[randomMsg].text;
		msg.textColor = AllRound_Extension.sayings.randomTexts[randomMsg].textColor;
		table.remove(AllRound_Extension.sayings.randomTexts, randomMsg);
		if #AllRound_Extension.sayings.randomTexts == 0 then AllRound_Extension.sayings.resetRandomMsg();end;
	elseif AllRound_Extension.sayings.types[types] ~= nil and #AllRound_Extension.sayings.types[types] > 0 then
		local randomMsg = math.random(1, #AllRound_Extension.sayings.types[types]);
		msg.text = AllRound_Extension.sayings.types[types][randomMsg].text;
		msg.textColor = AllRound_Extension.sayings.types[types][randomMsg].textColor;
		if removeTypesMsg then table.remove(AllRound_Extension.sayings.types[types], randomMsg);end;
	end;
	if types ~= nil and typesOrRandom and msg.text == nil then return AllRound_Extension.sayings.getRandomMsg();end;
	return msg;
end;

function AllRound_ExtensionSayings:addRandomMsg(args, resetTime)
	local id = g_currentMission.hlHudSystem.textTicker:addMsg( args );
	if resetTime then
		AllRound_ExtensionSayings:resetTime();		
	end;
	return id;
end;

function AllRound_ExtensionSayings:resetTime(byPlayer)
	if byPlayer then
		AllRound_Extension.sayings.nextTime = g_time + (AllRound_Extension.values.sayings.timer[1]*1000*60);
	else		
		AllRound_Extension.sayings.setNextTime();
	end;
end;

function AllRound_ExtensionSayings:resetRandomMsg()
	AllRound_Extension.sayings.randomTexts = {};
	for _,msg in pairs (AllRound_Extension.sayings.texts) do
		if msg.canRandom then
			table.insert(AllRound_Extension.sayings.randomTexts, msg);
		end;
	end;
end;

function AllRound_ExtensionSayings:createSayings()
	local interval = AllRound_Extension.values.sayings.timer[1];
	local firstInterval = 1;
	if interval > 30 then firstInterval = 2;end;
	interval = interval*1000*60;
	AllRound_Extension.sayings = {		
		getRandomMsg = function(types) return AllRound_ExtensionSayings:getRandomMsg(types);end;
		addRandomMsg = function(args, resetTime) return AllRound_ExtensionSayings:addRandomMsg(args, resetTime);end;
		resetRandomMsg = function() AllRound_ExtensionSayings:resetRandomMsg();end;
		resetTime = function(byPlayer) AllRound_ExtensionSayings:resetTime(byPlayer);end;
		textColor = "ls22";
		beginTime = g_time;
		lastTime = 0;		
		interval = interval;
		nextTime = g_time + interval/firstInterval;
		lastJokeTime = g_time + AllRound_Extension.values.sayings.jokeTimer[1]*1000*60;
		nextJokeTime = g_time + AllRound_Extension.values.sayings.jokeTimer[1]*1000*60;
		texts = {};
		randomTexts = {};
		--viewTexts = {};
		types = {other={}};
		spezi = {};
		msgIcon = "jokeMsg"; --tostring(g_currentMission.hlUtils.getRandomByKey( {jokeMsg=80,colorJokeMsg=20} ));
		acceptsLanguage = {};
	};
	AllRound_ExtensionSayings:loadSayingsXml();
	local sayings = AllRound_Extension.sayings;
	--print(DebugUtil.printTableRecursively(sayings, "sayings ", 0, 3))
	sayings.canViewText = function() return g_time >= AllRound_Extension.sayings.nextTime;end;
	sayings.setNextTime = function() AllRound_Extension.sayings.nextTime = g_time + AllRound_Extension.sayings.interval;AllRound_Extension.sayings.lastTime = g_time;end;
	sayings.canViewJokeText = function() return g_time >= AllRound_Extension.sayings.nextJokeTime and AllRound_Extension.sayings.lastTime+200000 <= g_time;end;
	sayings.setNextJokeTime = function() AllRound_Extension.sayings.nextJokeTime = g_time + (AllRound_Extension.values.sayings.jokeTimer[1]*1000*60);AllRound_Extension.sayings.lastJokeTime = g_time;end;
	
	g_currentMission.hlHudSystem.textTicker.updateSayings = Utils.appendedFunction(g_currentMission.hlHudSystem.textTicker.updateSayings, AllRound_ExtensionSayings.updateSayings);	
end;

function AllRound_ExtensionSayings:loadSayingsXml()
	local playername = Utils.getNoNil(g_gameSettings.onlinePresenceName, g_i18n:getText("ui_players"));
	AllRound_ExtensionSayings:loadTexts(playername); --intern
	AllRound_ExtensionSayings:loadTexts(playername, true); --extern
	AllRound_ExtensionSayings:loadLsTexts(playername); --random ls22
end;

function AllRound_ExtensionSayings:loadTexts(playerName, extern)	
	local l10nFilenamePrefix = "languages/l10nSayings";
	local l10nFilenamePrefixFull = Utils.getFilename("scripte_are/".. l10nFilenamePrefix, g_currentMission.hlHudSystem.modDir);
	if extern then
		l10nFilenamePrefixFull = Utils.getFilename("modSettings/HL/FS25_AllRoundExtension/".. l10nFilenamePrefix, getUserProfileAppPath());
	end;
	local langs = {
		g_languageShort,
		"de"
	};
	local found = false;
	local xmlFile = nil;
	for _, lang in ipairs(langs) do
		xmlFile = l10nFilenamePrefixFull.. "_".. lang.. ".xml";
		if fileExists(xmlFile) then
			if AllRound_Extension.sayings.acceptsLanguage[lang] == nil then AllRound_Extension.sayings.acceptsLanguage[lang] = true;end;
			found = true;
			break;
		end;
	end;
	if found and xmlFile ~= nil then AllRound_ExtensionSayings:loadXmlTexts(xmlFile, playerName);end;
end;

function AllRound_ExtensionSayings:loadLsTexts(playerName) --ls22	
	--if math.random(1,5) == 3 then
		local texts = {
			playerName.. "! ".. g_i18n:getText("ui_howDoYouLikeTheGame"),
			playerName.. "! ".. g_i18n:getText("achievement_nameLoadedOldSavegame"),
			playerName.. "! ".. g_i18n:getText("achievement_descPetDog"),	
			g_i18n:getText("achievement_nameDeliveryOlives").. " ".. playerName,
			g_i18n:getText("achievement_descBreedCows").. " ".. g_i18n:getText("achievement_descBreedPigs"),
			playerName.. "! ".. g_i18n:getText("achievement_descCollectiblesUS"),
			g_i18n:getText("achievementFileDescription_psn").. ". Davon kann man nicht genug kriegen", 
			g_i18n:getText("ui_ingameMenuHelpLine").. " ".. playerName.. " ".. g_i18n:getText("achievement_descMoney"),
			playerName.. "! ".. g_i18n:getText("achievement_descNumDrivables"),
			playerName.. "! ".. g_i18n:getText("achievement_descNumPlaceables"),
			g_i18n:getText("achievement_descSowFirst").. playerName.. " ".. g_i18n:getText("function_mower"),
			playerName.. " ".. g_i18n:getText("achievement_descVehicleRepaint"),
			g_i18n:getText("achievement_descVehicleRepairFirst").. " ".. playerName,
			g_i18n:getText("achievement_nameBreedChicken").. " ".. g_i18n:getText("achievement_descPlayTime"),
			playerName.. " ... ".. g_i18n:getText("achievement_nameBreedCows"),
			g_i18n:getText("achievement_nameBreedPigs").. " ".. g_i18n:getText("achievement_nameBreedSheep"),	
			playerName.. " ... ".. g_i18n:getText("achievement_nameCarDriving").. " ".. g_i18n:getText("achievement_nameCollectiblesUS"),
			g_i18n:getText("achievement_nameCutTreeFirst").. " ".. playerName.. " Immer der Nase nach",
			g_i18n:getText("achievement_nameDeliverySorghum").. " ".. playerName.. ". ".. g_i18n:getText("achievement_nameDeliveryGrapes"),
			g_i18n:getText("achievement_descTruckDriving").. " ".. playerName,
			g_i18n:getText("achievement_nameGotAllAchievements").. " ".. g_i18n:getText("achievement_nameHarvested"),
			g_i18n:getText("achievement_nameHarvestedFirst").. " ".. g_i18n:getText("achievement_nameHorseJumps"),
			playerName.. " ... ".. g_i18n:getText("achievement_nameMission"),
			g_i18n:getText("achievement_nameMissionFirst").. " ".. g_i18n:getText("achievement_nameMoney").. " ".. playerName,
			g_i18n:getText("achievement_nameNumBeehives"),
			g_i18n:getText("achievement_descCultivate"),
			playerName.. " ... ".. g_i18n:getText("achievement_descCultivateFirst"),
			playerName.. "! ".. g_i18n:getText("achievement_descCutTreeFirst").. " ".. g_i18n:getText("achievement_descCutTree"),
			g_i18n:getText("achievement_descHarvestedFirst"),
			g_i18n:getText("ui_collectibleMessageTitle").. " ".. g_i18n:getText("achievement_nameWrappedBales"),
			g_i18n:getText("achievement_nameCultivateFirst"),	
			g_i18n:getText("achievement_descDeliveryGrapes"),
			g_i18n:getText("achievement_nameNumProductionPoints").. " ".. playerName,
			g_i18n:getText("achievement_descMissionFirst"),
			g_i18n:getText("achievement_descFertilizeFirst"),
			playerName.. "! ".. g_i18n:getText("achievement_nameSowFirst"),
			g_i18n:getText("achievement_nameNumPlaceables").. " ".. playerName,
			g_i18n:getText("achievement_nameTruckDriving").. " ".. playerName.. ". ".. g_i18n:getText("achievement_nameNumVehiclesSmall"),
			g_i18n:getText("achievement_namePetDog").. " ".. playerName,
			g_i18n:getText("achievement_namePlayTime").. " ".. playerName.. ". ".. g_i18n:getText("achievement_nameTractorDriving").. " statt Gackern.",
			g_i18n:getText("achievement_nameSow"),
			g_i18n:getText("achievement_nameVehicleRepaint").. " ".. g_i18n:getText("achievement_nameVehicleRepairFirst"),
			g_i18n:getText("achievement_descGotAllAchievements"),
			g_i18n:getText("info_tipSideBack").. " ".. g_i18n:getText("achievement_descFertilize"),
			playerName.. "! ".. g_i18n:getText("achievement_descDeliveryStones"),
			g_i18n:getText("achievement_descDeliverySorghum"),
			playerName.. "! ".. g_i18n:getText("achievement_descDeliveryOlives"),
			"2 ".. g_i18n:getText("statistic_eggsCarrying").. " ".. g_i18n:getText("achievement_descCottonBales"),
			g_i18n:getText("achievement_nameHorseRiding").. " ".. g_i18n:getText("achievement_nameHorseJumpsFirst"),
			g_i18n:getText("ui_kickTitle").. " ".. g_i18n:getText("achievement_descNumBeehives"),
			g_i18n:getText("achievement_nameHorseRidingFirst").. " ".. g_i18n:getText("achievement_descHorseRidingFirst")
		}; 
		for _,msg in pairs (texts) do		
			local saying = {
				text = msg;
				textColor = "ls22";
				isView = 0;				
				canRandom = true;
				types = "ls";
			};
			table.insert(AllRound_Extension.sayings.texts, saying);
			table.insert(AllRound_Extension.sayings.randomTexts, saying);
			if AllRound_Extension.sayings.types["ls"] == nil then AllRound_Extension.sayings.types["ls"] = {};end;
			table.insert(AllRound_Extension.sayings.types["ls"], saying);
		end;
	--end;	
end;

function AllRound_ExtensionSayings:loadXmlTexts(xmlFile, playerName)
	local Xml = loadXMLFile("Sayings_XML", xmlFile, "sayings");
	if Xml == nil then return;end;
	local playername = playerName or Utils.getNoNil(g_gameSettings.onlinePresenceName, g_i18n:getText("ui_players"));
	local formatTages = {playername=playername};	
	local sayings = AllRound_Extension.sayings;	
	local textKey = 0;			
	while true do
		local key = string.format("l10n.sayings.text(%d)", textKey);
		
		if not hasXMLProperty(Xml, key) then
			break;
		end;
		local canRandom = true;
		if getXMLBool(Xml, key.. "#random") ~= nil then canRandom = getXMLBool(Xml, key.. "#random");end;
		local color = getXMLString(Xml, key.. "#color") or sayings.textColor;
		local formatTag = getXMLString(Xml, key.. "#format");
		local spezi = getXMLString(Xml, key.. "#spezi");
		local types = getXMLString(Xml, key.. "#type") or "other";
		local text = getXMLString(Xml, key.. "#v");
		
		if text ~= nil then
			if types == nil then types = "other";end;
			if formatTag ~= nil and formatTages[formatTag] ~= nil then text = string.format(text, formatTages[formatTag]);end;
			local saying = {
				text = text:gsub("/n/", "\n");
				textColor = color;
				isView = 0;
				spezi = spezi;
				canRandom = canRandom;
				types = types;
			};
			table.insert(sayings.texts, saying);					
			
			if sayings.types[types] == nil then sayings.types[types] = {};end;
			table.insert(sayings.types[types], saying);
								
			if spezi ~= nil then
				if sayings.spezi[spezi] == nil then sayings.spezi[spezi] = {};end;
				table.insert(sayings.spezi[spezi], saying);
			end;
			
			if canRandom == true then
				table.insert(sayings.randomTexts, saying);
			end;
		end;
		textKey = textKey+1;
	end;
	delete(Xml);		
end;