AllRound_Extension_XmlGuiBox = {};

function AllRound_Extension_XmlGuiBox:defaultValues(guiBox)
	guiBox.ownTable = {
		icon = {};		
	};		
end;

function AllRound_Extension_XmlGuiBox:onLoadXml(guiBox, Xml, xmlNameTag)
	if guiBox.ownTable.icon == nil then AllRound_Extension_XmlGuiBox:defaultValues(guiBox);end;	
	if Xml ~= nil and xmlNameTag ~= nil then	
		if getXMLInt(Xml, xmlNameTag.."#version") ~= nil then 
						
		else
			return; --first config not found
		end;
		local groupNameTag = (xmlNameTag.. ".handTool(%d)"):format(0);
		--if getXMLBool(Xml, groupNameTag.."#switch") ~= nil then 
		--	AllRound_Extension.values.handTool.switch = getXMLBool(Xml, groupNameTag.. "#switch");
		--end;
		
		groupNameTag = (xmlNameTag.. ".miniMap(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.."#empty") ~= nil then 
			AllRound_Extension.values.miniMapState[1] = getXMLBool(Xml, groupNameTag.. "#empty");
		end;
		if getXMLBool(Xml, groupNameTag.."#round") ~= nil then 
			AllRound_Extension.values.miniMapState[2] = getXMLBool(Xml, groupNameTag.. "#round");
		end;
		if getXMLBool(Xml, groupNameTag.."#quadrat") ~= nil then 
			AllRound_Extension.values.miniMapState[3] = getXMLBool(Xml, groupNameTag.. "#quadrat");
		end;
		if not AllRound_Extension.values.miniMapState[1] and not AllRound_Extension.values.miniMapState[2] and not AllRound_Extension.values.miniMapState[3] then AllRound_Extension.values.miniMapState[1] = true;end;
		
		groupNameTag = (xmlNameTag.. ".weather(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.."#clickFrame") ~= nil then 
			AllRound_Extension.values.weather.clickFrame = getXMLBool(Xml, groupNameTag.. "#clickFrame");			
		end;
		if getXMLBool(Xml, groupNameTag.."#rainInfo") ~= nil then 
			AllRound_Extension.values.weather.rainInfo = getXMLBool(Xml, groupNameTag.. "#rainInfo");			
		end;
		if getXMLBool(Xml, groupNameTag.."#textIsRainInfo") ~= nil then 
			AllRound_Extension.values.weather.textIsRainInfo.isOn = getXMLBool(Xml, groupNameTag.. "#textIsRainInfo");			
		end;
		if getXMLInt(Xml, groupNameTag.."#textColor") ~= nil then 
			AllRound_Extension.values.weather.textColor = getXMLInt(Xml, groupNameTag.. "#textColor");
			if AllRound_Extension.values.weather.textColor >= 0 and AllRound_Extension.values.textColor[AllRound_Extension.values.weather.textColor] == nil then AllRound_Extension.values.weather.textColor = 1;end;
		end;
		
		--groupNameTag = (xmlNameTag.. ".temperatur(%d)"):format(0);
		--if getXMLBool(Xml, groupNameTag.."#icon") ~= nil then 
		--	AllRound_Extension.values.temperatur.icon = getXMLBool(Xml, groupNameTag.. "#icon");
		--	if AllRound_Extension.values.temperatur.icon then AllRound_ExtensionSetGet:setTemperaturIcon();end;
		--end;
		--if getXMLBool(Xml, groupNameTag.."#iconColor") ~= nil then 
		--	AllRound_Extension.values.temperatur.iconColor = getXMLBool(Xml, groupNameTag.. "#iconColor");
		--end;
		--if getXMLBool(Xml, groupNameTag.."#current") ~= nil then 
		--	AllRound_Extension.values.temperatur.current = getXMLBool(Xml, groupNameTag.. "#current");
		--end;
		--if getXMLBool(Xml, groupNameTag.."#currentColor") ~= nil then 
		--	AllRound_Extension.values.temperatur.currentColor = getXMLBool(Xml, groupNameTag.. "#currentColor");
		--end;
		
		groupNameTag = (xmlNameTag.. ".season(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.."#yearsPlayed") ~= nil then 
			AllRound_Extension.values.season.yearsPlayed = getXMLBool(Xml, groupNameTag.. "#yearsPlayed");
		end;
		if getXMLInt(Xml, groupNameTag.."#textColor") ~= nil then 
			AllRound_Extension.values.season.textColor = getXMLInt(Xml, groupNameTag.. "#textColor");
			if AllRound_Extension.values.season.textColor >= 0 and AllRound_Extension.values.textColor[AllRound_Extension.values.season.textColor] == nil then AllRound_Extension.values.season.textColor = 1;end;
		end;
		
		groupNameTag = (xmlNameTag.. ".ingameTime(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.."#clickFrame") ~= nil then 
			AllRound_Extension.values.ingameTime.clickFrame = getXMLBool(Xml, groupNameTag.. "#clickFrame");
		end;
		if getXMLInt(Xml, groupNameTag.."#timeScaleDefault") ~= nil then
			local scaleTime = getXMLInt(Xml, groupNameTag.."#timeScaleDefault");			
			if Platform.gameplay.timeScaleSettings[scaleTime] == nil then scaleTime = Platform.gameplay.defaultTimeScale;end;
			--if Platform.gameplay.timeScaleSettings[scaleTime] == nil then scaleTime = Platform.gameplay.timeScaleSettings[1];end;
			AllRound_Extension.values.ingameTime.defaultTimeScale = scaleTime;
		end;
		if getXMLBool(Xml, groupNameTag.."#timeScaleColor") ~= nil then 
			AllRound_Extension.values.ingameTime.timeScaleColor = getXMLBool(Xml, groupNameTag.. "#timeScaleColor");
		end;
		if getXMLBool(Xml, groupNameTag.."#playDays") ~= nil then 
			AllRound_Extension.values.ingameTime.playDays = getXMLBool(Xml, groupNameTag.. "#playDays");
		end;
		
		groupNameTag = (xmlNameTag.. ".realDayTime(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.."#dayTime") ~= nil then 
			AllRound_Extension.values.realDayTime.dayTime = getXMLBool(Xml, groupNameTag.. "#dayTime");
		end;
		--if getXMLBool(Xml, groupNameTag.."#dayLarge") ~= nil then 
		--	AllRound_Extension.values.realDayTime.dayLarge = getXMLBool(Xml, groupNameTag.. "#dayLarge");
		--end;
		if getXMLBool(Xml, groupNameTag.."#format12") ~= nil then 
			AllRound_Extension.values.realDayTime.format12 = getXMLBool(Xml, groupNameTag.. "#format12");
		end;
		if getXMLInt(Xml, groupNameTag.."#textColor") ~= nil then 
			AllRound_Extension.values.realDayTime.textColor = getXMLInt(Xml, groupNameTag.. "#textColor");
			if AllRound_Extension.values.realDayTime.textColor >= 0 and AllRound_Extension.values.textColor[AllRound_Extension.values.realDayTime.textColor] == nil then AllRound_Extension.values.realDayTime.textColor = 1;end;
		end;
		if getXMLBool(Xml, groupNameTag.."#date") ~= nil then 
			AllRound_Extension.values.realDayTime.date = getXMLBool(Xml, groupNameTag.. "#date");
		end;
		groupNameTag = (xmlNameTag.. ".otherSettings(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.."#vehicleSaleInfo") ~= nil then 
			AllRound_Extension.values.vehicleSaleSystem.isOn = getXMLBool(Xml, groupNameTag.. "#vehicleSaleInfo");
		end;
		if getXMLBool(Xml, groupNameTag.."#vehicleSaleTextInfo") ~= nil then 
			AllRound_Extension.values.vehicleSaleSystem.setInfo = getXMLBool(Xml, groupNameTag.. "#vehicleSaleTextInfo");
		end;
		if getXMLBool(Xml, groupNameTag.."#playerSuperSpeed") ~= nil then 
			AllRound_Extension.values.superSpeed = getXMLBool(Xml, groupNameTag.. "#playerSuperSpeed");
			if AllRound_Extension.values.superSpeed then AllRound_ExtensionSetGet:setPlayerSuperSpeed(true);end;
		end;
		if getXMLInt(Xml, groupNameTag.."#runningSpeed") ~= nil then 
			local speed = getXMLInt(Xml, groupNameTag.. "#runningSpeed");
			if speed < AllRound_Extension.values.superSpeedMover[2] or speed > AllRound_Extension.values.superSpeedMover[3] then AllRound_Extension.values.superSpeedMover[1] = AllRound_Extension.values.superSpeedMover[3];else AllRound_Extension.values.superSpeedMover[1] = speed;end;			
		end;
		if getXMLBool(Xml, groupNameTag.."#playerSuperStrength") ~= nil then 
			AllRound_Extension.values.superStrength = getXMLBool(Xml, groupNameTag.. "#playerSuperStrength"); 
			if AllRound_Extension.values.superStrength then AllRound_Extension.values.superStrengthOnLoad = true;end; --AllRound_ExtensionSetGet:setPlayerSuperStrength(true);end;
		end;
		groupNameTag = (xmlNameTag.. ".otherSpeciale(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.."#adShowMarkersOnMinimap") ~= nil then 
			AllRound_Extension.values.ad.showMarkersOnMinimap = getXMLBool(Xml, groupNameTag.. "#adShowMarkersOnMinimap");
		end;		
		if getXMLInt(Xml, groupNameTag.."#sayings") ~= nil then AllRound_Extension.values.sayings.on[1] = getXMLInt(Xml, groupNameTag.."#sayings");end;
		if getXMLInt(Xml, groupNameTag.."#sayingsTimer") ~= nil then AllRound_Extension.values.sayings.timer[1] = getXMLInt(Xml, groupNameTag.."#sayingsTimer");end;
		if getXMLInt(Xml, groupNameTag.."#sayingsJoke") ~= nil then AllRound_Extension.values.sayings.joke[1] = getXMLInt(Xml, groupNameTag.."#sayingsJoke");end;
		if getXMLInt(Xml, groupNameTag.."#sayingsJokeTimer") ~= nil then 
			local jokeTimer = getXMLInt(Xml, groupNameTag.."#sayingsJokeTimer");
			if jokeTimer < AllRound_Extension.values.sayings.jokeTimer[2] or jokeTimer > AllRound_Extension.values.sayings.jokeTimer[3] then jokeTimer = AllRound_Extension.values.sayings.jokeTimer[5];end;
			AllRound_Extension.values.sayings.jokeTimer[1] = jokeTimer;
		end;
		if getXMLInt(Xml, groupNameTag.."#sayingsJokeRandom") ~= nil then 
			local jokeRandom = getXMLInt(Xml, groupNameTag.."#sayingsJokeRandom");
			if jokeRandom < AllRound_Extension.values.sayings.jokeRandom[2] or jokeRandom > AllRound_Extension.values.sayings.jokeRandom[3] then jokeRandom = AllRound_Extension.values.sayings.jokeRandom[5];end;
			AllRound_Extension.values.sayings.jokeRandom[1] = jokeRandom;
		end;
		groupNameTag = (xmlNameTag.. ".mouseCursorMarker(%d)"):format(0);
		if getXMLBool(Xml, groupNameTag.."#isOn") ~= nil then 
			AllRound_Extension.values.mouseCursorMarker.isOn = getXMLBool(Xml, groupNameTag.. "#isOn");			
		end;
		if getXMLInt(Xml, groupNameTag.."#size") ~= nil then AllRound_Extension.values.mouseCursorMarker.size[1] = getXMLInt(Xml, groupNameTag.."#size");end;
		if getXMLInt(Xml, groupNameTag.."#color") ~= nil then AllRound_Extension.values.mouseCursorMarker.color = getXMLInt(Xml, groupNameTag.."#color");end;
		AllRound_ExtensionSetGet:setMouseCursorMarker(true);
	end;	
end;

function AllRound_Extension_XmlGuiBox.onSaveXml(guiBox, Xml, xmlNameTag)
	setXMLInt(Xml, xmlNameTag.."#version", AllRound_Extension.metadata.xmlVersion);
	
	local groupNameTag = (xmlNameTag.. ".handTool(%d)"):format(0);
	--setXMLBool(Xml, groupNameTag.."#switch", AllRound_Extension.values.handTool.switch);
	
	groupNameTag = (xmlNameTag.. ".miniMap(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.."#empty", AllRound_Extension.values.miniMapState[1]);
	setXMLBool(Xml, groupNameTag.."#round", AllRound_Extension.values.miniMapState[2]);
	setXMLBool(Xml, groupNameTag.."#quadrat", AllRound_Extension.values.miniMapState[3]);
	
	groupNameTag = (xmlNameTag.. ".weather(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.."#clickFrame", AllRound_Extension.values.weather.clickFrame);
	setXMLBool(Xml, groupNameTag.."#rainInfo", AllRound_Extension.values.weather.rainInfo);
	setXMLBool(Xml, groupNameTag.."#textIsRainInfo", AllRound_Extension.values.weather.textIsRainInfo.isOn);
	setXMLInt(Xml, groupNameTag.."#textColor", AllRound_Extension.values.weather.textColor);
	
	groupNameTag = (xmlNameTag.. ".temperatur(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.."#icon", AllRound_Extension.values.temperatur.icon);
	setXMLBool(Xml, groupNameTag.."#iconColor", AllRound_Extension.values.temperatur.iconColor);
	setXMLBool(Xml, groupNameTag.."#current", AllRound_Extension.values.temperatur.current);
	setXMLBool(Xml, groupNameTag.."#currentColor", AllRound_Extension.values.temperatur.currentColor);
	
	groupNameTag = (xmlNameTag.. ".season(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.."#yearsPlayed", AllRound_Extension.values.season.yearsPlayed);
	setXMLInt(Xml, groupNameTag.."#textColor", AllRound_Extension.values.season.textColor);
	
	groupNameTag = (xmlNameTag.. ".ingameTime(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.."#clickFrame", AllRound_Extension.values.ingameTime.clickFrame);
	setXMLInt(Xml, groupNameTag.."#timeScaleDefault", AllRound_Extension.values.ingameTime.defaultTimeScale);
	setXMLBool(Xml, groupNameTag.."#timeScaleColor", AllRound_Extension.values.ingameTime.timeScaleColor);
	setXMLBool(Xml, groupNameTag.."#playDays", AllRound_Extension.values.ingameTime.playDays);
	
	groupNameTag = (xmlNameTag.. ".realDayTime(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.."#dayTime", AllRound_Extension.values.realDayTime.dayTime);
	--setXMLBool(Xml, groupNameTag.."#dayLarge", AllRound_Extension.values.realDayTime.dayLarge);
	setXMLBool(Xml, groupNameTag.."#format12", AllRound_Extension.values.realDayTime.format12);
	setXMLInt(Xml, groupNameTag.."#textColor", AllRound_Extension.values.realDayTime.textColor);
	setXMLBool(Xml, groupNameTag.."#date", AllRound_Extension.values.realDayTime.date);
	
	groupNameTag = (xmlNameTag.. ".otherSettings(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.."#vehicleSaleInfo", AllRound_Extension.values.vehicleSaleSystem.isOn);
	setXMLBool(Xml, groupNameTag.."#vehicleSaleTextInfo", AllRound_Extension.values.vehicleSaleSystem.setInfo);
	setXMLBool(Xml, groupNameTag.."#playerSuperSpeed", AllRound_Extension.values.superSpeed);
	setXMLInt(Xml, groupNameTag.."#runningSpeed", AllRound_Extension.values.superSpeedMover[1]);
	setXMLBool(Xml, groupNameTag.."#playerSuperStrength", AllRound_Extension.values.superStrength);
	
	groupNameTag = (xmlNameTag.. ".otherSpeciale(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.."#adShowMarkersOnMinimap", AllRound_Extension.values.ad.showMarkersOnMinimap);	
	setXMLInt(Xml, groupNameTag.."#sayings", AllRound_Extension.values.sayings.on[1]);
	setXMLInt(Xml, groupNameTag.."#sayingsTimer", AllRound_Extension.values.sayings.timer[1]);
	setXMLInt(Xml, groupNameTag.."#sayingsJoke", AllRound_Extension.values.sayings.joke[1]);
	setXMLInt(Xml, groupNameTag.."#sayingsJokeTimer", AllRound_Extension.values.sayings.jokeTimer[1]);
	setXMLInt(Xml, groupNameTag.."#sayingsJokeRandom", AllRound_Extension.values.sayings.jokeRandom[1]);
	
	groupNameTag = (xmlNameTag.. ".mouseCursorMarker(%d)"):format(0);
	setXMLBool(Xml, groupNameTag.."#isOn", AllRound_Extension.values.mouseCursorMarker.isOn);
	setXMLInt(Xml, groupNameTag.."#size", AllRound_Extension.values.mouseCursorMarker.size[1]);
	setXMLInt(Xml, groupNameTag.."#color", AllRound_Extension.values.mouseCursorMarker.color);
end;

function AllRound_Extension_XmlGuiBox:loadGuiBox(name, onSave)
	if name == "AllRound_Extension_GuiBox" then
		AllRound_Extension.values.guiMenu = g_currentMission.hlHudSystem.hlGuiBox.generate( {name="AllRound_Extension_GuiBox", title="AllRound-Extension Settings",onOverGuiBoxHudSystem=true} );
		AllRound_ExtensionGuiBoxSetGet:loadIcons(AllRound_Extension.values.guiMenu);
		local linesSequence = {"miniMapHeadline_","miniMapEmpty_","miniMapRound_","miniMapQuadrat_",
			--"temperaturHeadline_","temperaturIcon_","temperaturIconColor_","currentTemperatur_","currentTemperaturColor_",
			"weatherHeadline_","weatherClickFrame_","weatherRainInfo_","weatherRainInfoColor_","weatherTextIsRainInfo_",
			"seasonIngameTimeHeadline_","yearsPlayed_","ingamePlayDays_","yearsPlayedColor_","ingameTimeClickFrame_","defaultTimeScale_","timeScaleColor_",
			"realDayTimeHeadline_","realDayTime_","realFormat12_","realDate_","realTextColor_", --"realDayLarge_"
			"otherSettingsHeadline_","vehicleSaleInfo_","vehicleSaleTextInfo_","superSpeed_","superSpeedMover_","superStrength_","mouseCursorMarkerIsOn_","mouseCursorMarkerSize_","mouseCursorMarkerColor_", --"handToolSwitch_",
			"otherHeadline_","adShowMarkersOnMinimap_","sayings_","sayingsTimer_",		
		};
				
		AllRound_Extension.values.guiMenu.screen.canBounds.on = true;
		AllRound_Extension.values.guiMenu.onClick = AllRound_Extension_MouseKeyEventsGuiBox.onClickArea;
		AllRound_Extension.values.guiMenu.onSaveXml = AllRound_Extension_XmlGuiBox.onSaveXml;
		AllRound_Extension_XmlGuiBox:onLoadXml(AllRound_Extension.values.guiMenu, AllRound_Extension.values.guiMenu:getXml()); --own guiBox load over Xml (replace Data)
		AllRound_Extension.values.guiMenu.getLine = AllRound_ExtensionGuiBoxSetGet.getLines;
		AllRound_Extension.values.guiMenu.guiLines = {};
		for k,v in pairs(linesSequence) do
			table.insert(AllRound_Extension.values.guiMenu.guiLines, v);
		end;		
		for l=1, #AllRound_Extension.values.guiMenu.guiLines do
			AllRound_Extension.values.guiMenu:addLine( {} );
		end;
		AllRound_Extension.values.guiMenu:resetDimension();
		--GuiBox start over Hl Hud System		
	end;
end;