Financing_Vehicle = {}

function Financing_Vehicle:showInfo(box)

    local farmId = self:getOwnerFarmId()

    if farmId == nil then return end

    local farm = g_farmManager:getFarmById(farmId)

    if farm == nil or farm.financing == nil then return end

    for _, entry in pairs(farm.financing) do
        if entry.vehicle == self.uniqueId and not entry.paid then
            local entryPeriod = 1
            local entryYear = 1
            local env = g_currentMission.environment
            local period = env.currentPeriod
            local year = env.currentYear

            for a, b in string.gmatch(entry.date, "(%w+)-(%w+)") do
                entryPeriod = tonumber(a)
                entryYear = tonumber(b)
            end

            local totalPeriods = (12 * year) + period
            local finishedPeriods = (12 * entryYear) + entryPeriod

            local monthlyCost = (entry.amount - entry.amountPaid) / math.max((finishedPeriods + entry.length) - totalPeriods, 1)
            local monthsLeft = math.max((finishedPeriods + entry.length) - totalPeriods, 1)

            box:addLine(g_i18n:getText("financing_vehicleInfoMonthlyPayment"), g_i18n:formatMoney(monthlyCost, 2, true, true))
            box:addLine(g_i18n:getText("financing_vehicleInfoRemainingPayment"), g_i18n:formatMoney(entry.amount - entry.amountPaid, 2, true, true))

            if monthsLeft == 1 then
                box:addLine(g_i18n:getText("financing_vehicleInfoRemainingMonths"), g_i18n:getText("financing_vehicleInfoRemainingMonthsSingle"))
            else
                box:addLine(g_i18n:getText("financing_vehicleInfoRemainingMonths"), string.format(g_i18n:getText("financing_vehicleInfoRemainingMonthsPlural"), monthsLeft))
            end

            break
        end
    end

end

Vehicle.showInfo = Utils.appendedFunction(Vehicle.showInfo, Financing_Vehicle.showInfo)