-- registers a new fruitTypeCategory for earth fruits
local function register()
    local categoryName = "EARTHFRUITS"
    local fruitTypeCategoryIndex = g_fruitTypeManager:addFruitTypeCategory(categoryName, false)
    local fillTypeCategoryIndex = g_fillTypeManager:addFillTypeCategory(categoryName, false)

    for _, fruitTypeData in pairs(g_fruitTypeManager.fruitTypes) do
        if fruitTypeData ~= nil then
            local fruitTypeName = fruitTypeData.name
            local minPreparingGrowthState = fruitTypeData.minPreparingGrowthState
            local preparedGrowthState = fruitTypeData.preparedGrowthState
            local haulmLayerName = fruitTypeData.haulmLayerName

            -- check if fruit is needs herb removement to be harvested
            if (minPreparingGrowthState ~= -1 or preparedGrowthState ~= -1 or haulmLayerName ~= nil or fruitTypeName == "ONION") and fruitTypeName ~= "SUGARCANE" and not string.contains(fruitTypeName, "RICE") then

                -- add fruitType to new fruitTypeCategory
                local fruitType = g_fruitTypeManager:getFruitTypeByName(fruitTypeName)

                if fruitType ~= nil then
                    if not g_fruitTypeManager:addFruitTypeToCategory(fruitType.index, fruitTypeCategoryIndex) or not g_fillTypeManager:addFillTypeToCategory(fruitType.fillType.index, fillTypeCategoryIndex) then
                        Logging.warning("Could not add fruitType '%s' to fruitTypeCategory '%s'!", fruitTypeName, categoryName)
                    else
                        Logging.devInfo("Added fruitType '%s' to fruitTypeCategory '%s'.", fruitTypeName, categoryName)
                    end
                else
                    Logging.warning("FruitType '%s' not defined!", fruitTypeName)
                end
            end
        end
    end
end

BaseMission.loadMapFinished = Utils.appendedFunction(BaseMission.loadMapFinished, register)