--[[
THIS LUA FIXES THE BASE GAME LUA TO ALLOW AI HARVESTING FOR MULTI FRUITS
by Sablerock
DO NOT COPY WITHOUT MY PERMISSION
date written: 2025/01/21
]]

print("====Ropa MultiFruitAI SABLEROCK====")

MultiFruitAI = {}

function MultiFruitAIfix(self,savegame)
	-- print("====function MultiFruitAIfix(self,savegame)====")
    local spec = self.spec_fruitPreparer
	
    spec.fruitTypes = {}
    local fruitTypes = self.xmlFile:getValue("vehicle.fruitPreparer#fruitTypes", {}, true)

    local fruitType = self.xmlFile:getValue("vehicle.fruitPreparer#fruitType")
    if fruitType ~= nil then
        table.insert(fruitTypes, fruitType)
    end

    if #fruitTypes > 0 then
        for _, fruitType in ipairs(fruitTypes) do
            local desc = g_fruitTypeManager:getFruitTypeByName(fruitType)
            if desc ~= nil then
                table.insert(spec.fruitTypes, desc.index)
				
				
				if desc.preparedGrowthState == -1 then
					desc.preparedGrowthState = 15;
				end;

                if self.setAIFruitRequirements ~= nil then
					-- print("===(haulm)AIFruitRequirements fruit: "..tostring(desc.index).." "..desc.name.." "..desc.fillType.title)
				
                    if desc.minPreparingGrowthState ~= -1 then
                        self:addAIFruitRequirement(desc.index, desc.minPreparingGrowthState, desc.maxPreparingGrowthState)

                        local aiUsePreparedState = self.xmlFile:getValue("vehicle.fruitPreparer#aiUsePreparedState", self.spec_cutter ~= nil)
                        if aiUsePreparedState then
                            self:addAIFruitRequirement(desc.index, desc.preparedGrowthState, desc.preparedGrowthState)
                        end
                    else
                        local minState = spec.allowsForageGrowthState and desc.minForageGrowthState or desc.minHarvestingGrowthState
                        self:addAIFruitRequirement(desc.index, minState, desc.maxHarvestingGrowthState)
                    end
				else
					-- print("===(other)AIFruitRequirements fruit: "..tostring(desc.index).." "..desc.name.." "..desc.fillType.title)
                    self:addAIFruitRequirement(desc.index, desc.minPreparingGrowthState, desc.maxPreparingGrowthState)
                end
            else
                Logging.xmlWarning(self.xmlFile, "Unable to find fruitType '%s' in fruitPreparer", fruitType)
            end
        end
    else
        Logging.xmlWarning(self.xmlFile, "Missing fruitType in fruitPreparer")
    end
end

FruitPreparer.onLoad = Utils.appendedFunction(FruitPreparer.onLoad, MultiFruitAIfix)
