loadMotionPathEffects = {}
local modDirectory = g_currentModDirectory

function loadMotionPathEffects.loadMapData(self, superFunc, xmlFile, missionInfo, baseDirectory)
    print("Info: Loading swathing plus motion path effects")
    --local returnValue = superFunc(self, xmlFile, missionInfo, baseDirectory)

    if fileExists(modDirectory.."xml/motionPathEffects.xml") then
        MotionPathEffectManager.createMotionPathEffectXMLSchema()

        local xml = loadXMLFile("motionPathEffects", modDirectory.."xml/motionPathEffects.xml")

        local i = 0
        while true do
            local motionPathEffect = getXMLString(xml, "motionPathEffects.motionPathEffect("..i..")#filename")
            if motionPathEffect ~= nil and motionPathEffect ~= "" then
                g_motionPathEffectManager:loadMotionPathEffectsXML(motionPathEffect, modDirectory, "FS25_swathingPlus")
            else
                break
            end
            i = i + 1
        end
	    
	    delete(xml)
    end

    return superFunc(self, xmlFile, missionInfo, baseDirectory)
end

MotionPathEffectManager.loadMapData = Utils.overwrittenFunction(MotionPathEffectManager.loadMapData, loadMotionPathEffects.loadMapData)