-- FS25_WetWheelTracks/main.lua

WetWheelTracks = {}
local modName = g_currentModName
local modDir  = g_currentModDirectory

-- Ladataan apuluokat ja varsinainen logiikka
source(modDir .. "scripts/UIHelper.lua")
source(modDir .. "scripts/WetWheelTracksSettings.lua")
source(modDir .. "scripts/WetWheelTracks.lua")

-- Luo settings-olio käyttäen WetWheelTracksSettings-luokkaa
WetWheelTracks.settings = WetWheelTracksSettings.new()

----------------------------------------------------------------
-- Hookit: asetukset & UI
----------------------------------------------------------------

-- Kun kartta on latautunut: lisää oma settings-osio ja lataa arvot XML:stä
BaseMission.loadMapFinished = Utils.prependedFunction(BaseMission.loadMapFinished, function(mission, node, ...)
    if mission ~= nil then
        WetWheelTracks.settings:addSettingsUiToGame()
        WetWheelTracks.settings:loadSettingsFromXml()
    end
end)

-- Kun InGameMenu suljetaan, tallenna asetukset vain jos muuttuneet
InGameMenu.onClose = Utils.appendedFunction(InGameMenu.onClose, function(...)
    WetWheelTracks.settings:maybeSaveSettingsToXml()
end)

-- Kun peli tallentaa, varmista että asetukset ovat levyllä
ItemSystem.save = Utils.appendedFunction(ItemSystem.save, function(...)
    WetWheelTracks.settings:saveSettingsToXml()
end)

----------------------------------------------------------------
-- Ajonaikainen update – overlay + kevyt debug
-- (Kitkan säätö tehdään WheelPhysics.serverUpdate-koukun kautta wetWheelTracks.lua:ssa)
----------------------------------------------------------------
BaseMission.update = Utils.appendedFunction(BaseMission.update, function(mission, dt, ...)
    if mission == g_currentMission and WetWheelTracks ~= nil and WetWheelTracks.update ~= nil then
        WetWheelTracks:update(dt)
    end
end)

print(string.format("[WetWheelTracks] Loaded mod '%s' from '%s'", tostring(modName), tostring(modDir)))
